<?php
$CI = get_instance();
$CI->load->database();
$CI->load->dbforge();

function init_field($type, $constraint = 255, $default = null, $null = true, $collation = 'utf8_unicode_ci')
{
    $column_type['type'] = ($type == 'id') ? 'INT' : strtoupper($type);
    $column_type['collation'] = $collation;

    if (!in_array($type, ['double', 'long', 'float', 'timestamp'])) {
        $column_type['constraint'] = $constraint;
    }

    if ($type == 'id') {
        $column_type['unsigned'] = true;
        $column_type['auto_increment'] = true;
    } else {
        $column_type['default'] = $default;
        $column_type['null'] = $null;
    }
    return $column_type;
}


$tables['notifications'] = [
    'id' => init_field('id'),
    'user_id' => init_field('int'),
    'notice_id' => init_field('int'),
    'message' => init_field('text'),
    'status' => init_field('varchar'),
    'created_at' => init_field('timestamp'),
];

// add new fields to the database
foreach ($tables as $key => $item) {
    $CI->dbforge->add_field($item);
    $CI->dbforge->add_key('id', TRUE);
    $attributes = array('collation' => "utf8_unicode_ci");
    $CI->dbforge->create_table($key, TRUE);
}



// update VERSION NUMBER INSIDE SETTINGS TABLE
$CI->db->where('id', 1);
$CI->db->update('settings', ['version' => '7.7']);
